#ifndef _fma_proxy_h_
#define _fma_proxy_h_
/*
 * Structures and definitions for dealing with being or having a proxy
 */

#define FMA_PROXY_CLIENT_ID_TIMEOUT 2000

/*
 * Information on how to reach the FMA which is serving as our proxy
 * to the FMS
 */
struct fma_proxy {
  struct fma_nic_info *nip;
  int port;
  unsigned char route[MYRI_MAX_ROUTE_LEN];
  int route_len;

  int client_id;		/* ID assigned by our proxy FMA */
  struct lf_event *timer;	/* timer for receiving client ID */
};

/*
 * This is a record of a proxy message in flight
 */
struct fma_proxy_msg {
  struct fma_myri_packet *hdr;
  char *msg;
  void (*callback)(void *);
  void *context;
};

/*
 * forward reference
 */
struct fma_myri_packet;
struct lf_proxy_fms_to_fma;
struct lf_proxy_fma_to_fms;

/*
 * prototypes
 */
void fma_proxy_initiate(struct fma_nic_info *nip, int port,
	  unsigned char *route, int route_len);
void fma_got_proxy_client_id_reply(struct fma_myri_packet *pkt);
void fma_got_proxy_client_id_request(struct fma_nic_info *nip,
	  int port, struct fma_myri_packet *pkt);
void fma_cancel_proxy_mode(void);


#endif /* _fma_proxy_h_ */
